import json
import re
from typing import Any


def extract_and_parse_json(content: str, keys: list[str]) -> dict[str, Any] | None:
    """
    Extracts JSON-like string from content and attempts to parse it.

    Args:
    content (str): The string to extract JSON from.

    Returns:
    dict: Parsed JSON object if successful, None otherwise.
    """
    match = re.search(r"\{[^{}]*(?:\{[^{}]*\}[^{}]*)*\}", content)
    if not match:
        print(f"Warning: Could not find JSON-like string in content: {content}")
        return None

    result = match.group()
    try:
        parsed = json.loads(result)
        if all(key in parsed for key in keys):
            return parsed
        else:
            print(f"Warning: not all keys {keys} found in {parsed.keys()}")
            return None
    except json.JSONDecodeError:
        print(f"Warning: Could not parse content as JSON: {content}")
        return None
